<?php
try {
	require('connect.php');
	include "config.php";

	if (isset($_GET['validate_key'])) {
		$validate_key = $_GET['validate_key'];
	}
	if (isset($_GET['user_idnumber'])) {
		$user_idnumber = $_GET['user_idnumber'];
	}
	$curso = NULL;
	if (isset($_GET['curso'])) {
		$curso = $_GET['curso'];
	}
	
	if ($curso == "0") {
		$sql = "SELECT * FROM inscricao2 WHERE validate_key = :key AND user_codHT = :userId";
	} else {
		$sql = "SELECT * FROM inscricao WHERE validate_key = :key AND user_idnumber = :userId";
		#echo '<pre> AQUI';var_dump($sql,$validate_key,$user_idnumber);exit;
	}
	$statement = $conn->prepare($sql);
	$statement->bindValue(':key', $validate_key);
	$statement->bindValue(':userId', $user_idnumber);
	$statement->execute();
	$row = $statement->fetch(PDO::FETCH_ASSOC);
	
	// Check if $row contains data before accessing array keys
	if ($row !== false) {
		$id = $row['id'];
		$course_id = isset($row['course_id']) ? $row['course_id'] : null;
		if ($curso == "0") {
			$user_idnumber = $row['user_codHT'];
		} else {
			$user_idnumber = $row['user_idnumber'];
		}
	}
?>
<!DOCTYPE html>
<html>
<head>
<h1>Ficha de Inscrição | Declaração de Dados Pessoais </h1>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0">
<link rel="shortcut icon" href="favicon.ico" />
<link rel="icon" type="image/png" sizes="32x32" href="favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="favicon-16x16.png">
<link rel="stylesheet" href="css/estilos.css">
<link rel="stylesheet" href="css/sky-forms.css">
<link rel="stylesheet" href="css/sky-forms-orange.css">
<script src="js/jquery.min.js"></script>
<script src="js/jquery.form.min.js"></script>
<script src="js/jquery.validate.min.js"></script>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.0/jquery.mask.js"></script>
<style>
    .select2-container {
        /*width: 100% !important;*/
        font-family: 'Open Sans', Helvetica, Arial, sans-serif;
        font-size: 14px;
    }
    .select2-container .select2-selection--single {
        height: 37px;
        border: 1px solid #ddd;
        border-radius: 3px;
    }
    .select2-container--default .select2-selection--single .select2-selection__rendered {
        line-height: 37px;
        padding-left: 12px;
        color: #404040;
    }
    .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: 37px;
    }
    .flag-icon {
        margin-right: 5px;
        width: 20px;
        height: 15px;
        background-size: contain;
        background-repeat: no-repeat;
        display: inline-block;
        vertical-align: middle;
    }
    .flag-icon-pt { background-image: url('https://cdn.jsdelivr.net/npm/flag-icon-css@3.5.0/flags/4x3/pt.svg'); }
    .flag-icon-br { background-image: url('https://cdn.jsdelivr.net/npm/flag-icon-css@3.5.0/flags/4x3/br.svg'); }
    .flag-icon-us { background-image: url('https://cdn.jsdelivr.net/npm/flag-icon-css@3.5.0/flags/4x3/us.svg'); }
    .flag-icon-gb { background-image: url('https://cdn.jsdelivr.net/npm/flag-icon-css@3.5.0/flags/4x3/gb.svg'); }
    .flag-icon-es { background-image: url('https://cdn.jsdelivr.net/npm/flag-icon-css@3.5.0/flags/4x3/es.svg'); }
    .flag-icon-fr { background-image: url('https://cdn.jsdelivr.net/npm/flag-icon-css@3.5.0/flags/4x3/fr.svg'); }
    .flag-icon-de { background-image: url('https://cdn.jsdelivr.net/npm/flag-icon-css@3.5.0/flags/4x3/de.svg'); }
    .flag-icon-it { background-image: url('https://cdn.jsdelivr.net/npm/flag-icon-css@3.5.0/flags/4x3/it.svg'); }
    .flag-icon-ao { background-image: url('https://cdn.jsdelivr.net/npm/flag-icon-css@3.5.0/flags/4x3/ao.svg'); }
    .flag-icon-cv { background-image: url('https://cdn.jsdelivr.net/npm/flag-icon-css@3.5.0/flags/4x3/cv.svg'); }
    .flag-icon-gq { background-image: url('https://cdn.jsdelivr.net/npm/flag-icon-css@3.5.0/flags/4x3/gq.svg'); }
    .flag-icon-gw { background-image: url('https://cdn.jsdelivr.net/npm/flag-icon-css@3.5.0/flags/4x3/gw.svg'); }
    .flag-icon-mz { background-image: url('https://cdn.jsdelivr.net/npm/flag-icon-css@3.5.0/flags/4x3/mz.svg'); }
    .flag-icon-st { background-image: url('https://cdn.jsdelivr.net/npm/flag-icon-css@3.5.0/flags/4x3/st.svg'); }
    .flag-icon-tl { background-image: url('https://cdn.jsdelivr.net/npm/flag-icon-css@3.5.0/flags/4x3/tl.svg'); }
</style>
</head>
<body class="bg-orange">
<div class="body">
<form method="post" id="sky-form" name="sky-form" class="sky-form">
	<?php
	if ($row == false) {
	?>
		<div style="background-color: red">
			<div style="color: white; margin-left: 30px">
				<br><br>
				<p><strong>Dados do link inválidos!</strong></p><br><br>
			</div>
		</div>
	</body>

	</html>
	<?php
				} else {
					if ($row['inqueritoFill'] == 1) 
					{
	?>
		<div style="background-color: #cc5000">
			<div style="color: white; margin-left: 30px">
				<br><strong>
					<p>Caro/a formando/a,</p>
					<p>Já recebemos a sua resposta a este questionário, a qual agradecemos novamente.</p>
					<p>Caso surja alguma dificuldade, queira por favor contactar os nossos serviços (+351 225 492 190).</p>
					<br>
				</strong>
			</div>
		</div>
		</body>
		</html>
	<?php
					} else {
	?>
		<fieldset>
			<?php
						if ($curso != "0") {
			?>
				<section>
					<h2>Identificação Curso</h2>
					<h4>Formação a que se candidata:</h4>
					<?php echo $row['formacao']; ?><br>
					<h4>Edição nº: </h4>
					<?php echo $row['edicao']; ?><br>
					<div class="inline-group">
						<input name="local" type="radio" <?php if ($row['local'] == 1) { ?>checked=checked <?php } ?> disabled value="Presencial - Local: Sala Virtual">Presencial - Local: Sala Virtual
						<input name="local" type="radio" <?php if ($row['local'] == 0) { ?>checked=checked <?php } ?> disabled value="E-learning/Live Streaming">E-learning/Live Streaming
					</div>
				</section>
			<?php
						}
			?>
			<section>
				<h2>Dados Pessoais</h2>
				<h4>Nome Completo:</h4>
					<label class="input">
						<input type="text" name="nomecompleto" id="nomecompleto" value="<?php echo $row['nomecompleto']; ?>">
					    <input type="hidden" id="curso" name="curso" value="<?php echo $curso; ?>"> 
					</label><br>
				<h4>Sexo:</h4>
					<div class="inline-group">
						<input name="sexo" id = "sexo" type="radio" <?php if ($row['sexo'] == 'M') { ?>checked=checked <?php } ?> value="M">Masculino
						<input name="sexo" id = "sexo" type="radio" <?php if ($row['sexo'] == 'F') { ?>checked=checked <?php } ?> value="F">Feminino
					</div><br>
				<h4>Morada:</h4>
					<label class="input">
						<input type="text" name="morada" id="morada" value="<?php echo $row['morada']; ?>">
					</label><br>
				<h4>Código Postal:</h4>
					<label class="input">
						<input type="text" name="codigopostal" minlength="8" placeholder = "0000-000" pattern="\d{4}-\d{3}" id="codigopostal" value="<?php echo $row['codigopostal']; ?>">
					</label><br>
				<h4>Localidade:</h4>
					<label class="input">
						<input type="text" name="localidade" id="localidade" value="<?php echo $row['localidade']; ?>">
					</label><br>

					<div class="row" style="display: flex; align-items: center; margin-left: 0px;">
						<h4>Telemóvel:</h4>
						<label class="input inline-group"  style="display: flex; gap: 10px;">
							<select name="phone_country" id="phone_country" class="select2-flags">
								<option value="">Selecione o País</option>
								<option value="+351" data-flag="pt">Portugal (+351)</option>
								<option value="+55" data-flag="br">Brasil (+55)</option>
								<option value="+1" data-flag="us">EUA (+1)</option>
								<option value="+44" data-flag="gb">Reino Unido (+44)</option>
								<option value="+34" data-flag="es">Espanha (+34)</option>
								<option value="+33" data-flag="fr">França (+33)</option>
								<option value="+49" data-flag="de">Alemanha (+49)</option>
								<option value="+39" data-flag="it">Itália (+39)</option>
								<option value="+244" data-flag="ao">Angola (+244)</option>
								<option value="+238" data-flag="cv">Cabo Verde (+238)</option>
								<option value="+240" data-flag="gq">Guiné Equatorial (+240)</option>
								<option value="+245" data-flag="gw">Guiné-Bissau (+245)</option>
								<option value="+258" data-flag="mz">Moçambique (+258)</option>
								<option value="+239" data-flag="st">São Tomé e Príncipe (+239)</option>
								<option value="+670" data-flag="tl">Timor-Leste (+670)</option>
							</select>
							<input type="text" name="telemovel" id="telemovel" minlength="9" placeholder="Número sem código do país" value="<?php echo $row['telemovel']; ?>">
						<br>
						</label>
						<br>
					</div>

				<h4>E-mail:</h4>
					<label class="input">
						<input type="text" name="email" id="email" value="<?php echo $row['email']; ?>">
					</label><br>

				<h4>NIF:</h4>
					<label class="input">
					<?php
						if ($curso != "0")
						{
						?>
						    <input type="text" name="NC" minlength="9" placeholder = "000000000" pattern="\d{9}" id="NC" value="<?php echo $row['user_idnumber']; ?>">
				    <?php
					    }
						else{ 
						?>
						    <input type="text" name="NC" minlength="9" placeholder = "000000000" pattern="\d{9}" id="NC" value="<?php echo $row['NC']; ?>">
						<?php
						}
						?>
					</label><br>
				<h4></h4>
					<label class="inline-group">
						<input type="checkbox" id="nifEstrangeiro" name="nifEstrangeiro"> <label for="nifEstrangeiro">NIF Estrangeiro</label>
					</label>
					<br>
				<h4>Data de Nascimento:</h4>
					<label class="input">
						<input type="date" name="datanascimento" id="datanascimento" value="<?php echo $row['datanascimento']; ?>">
					</label><br>
				<h4>NISS:</h4>
					<label class="input">
						<input type="text" name="niss" id="niss" minlength="11" maxlength="11" placeholder="Número de Identificação de Segurança Social" value="<?php echo isset($row['niss']) ? $row['niss'] : ''; ?>">
					</label><br>
				<label class="select">
					<h4>Estado Civil:</h4>
					<select name="estado_civil" id="estado_civil" required>
						<option value=''>Selecione Estado Civil</option>
						<option value='S' <?= isset($row['estado_civil']) && $row['estado_civil'] == 'S' ? 'selected' : ''; ?>>Solteiro</option>
						<option value='C' <?= isset($row['estado_civil']) && $row['estado_civil'] == 'C' ? 'selected' : ''; ?>>Casado</option>
						<option value='U' <?= isset($row['estado_civil']) && $row['estado_civil'] == 'U' ? 'selected' : ''; ?>>União de facto</option>
						<option value='P' <?= isset($row['estado_civil']) && $row['estado_civil'] == 'P' ? 'selected' : ''; ?>>Divorciado</option>
						<option value='X' <?= isset($row['estado_civil']) && $row['estado_civil'] == 'X' ? 'selected' : ''; ?>>Separado</option>
						<option value='V' <?= isset($row['estado_civil']) && $row['estado_civil'] == 'V' ? 'selected' : ''; ?>>Viúvo</option>
					</select>
				</label>
				<label class="select">
					<h4>Nacionalidade:</h4>
					<select name="nacionalidade" id="nacionalidade" class="select2-search" required>
						<option value=''>Selecione Nacionalidade</option>
						<?php
						$stmt = $conn->prepare("SELECT * FROM nacionalidade ORDER BY nacionalidade");
						$stmt->execute();
						$countriesList = $stmt->fetchAll();
						foreach ($countriesList as $country) {
						    if($row['nacionalidade'] == $country['nacionalidade'])
							    echo "<option value='" . $country['codigo_pais'] . "' selected>" . $country['nacionalidade'] . "</option>";
			                else echo "<option value='" . $country['codigo_pais'] . "'>" . $country['nacionalidade'] . "</option>";
						}
						?>
					</select>
				</label>
				<label class="select">
					<h4>País de Nascimento:</h4>
						<select name="pais" id="pais" class="select2-search" onchange="changePurpose()" required>
							<option value=''>Selecione Pais</option>
							<?php
							$stmt = $conn->prepare("SELECT * FROM countries ORDER BY countryname");
							$stmt->execute();
							$countriesList = $stmt->fetchAll();
							foreach ($countriesList as $country) {
							    echo "<option value='" . $country['id'] . "'>" . $country['countryname'] . "</option>";
							}
							?>
						</select>
				</label>				
				<label class="select">					
					<h4>Distrito Naturalidade:</h4>
						<select name="distrito" id="distrito">
							<option value=''>Selecione Distrito</option>
						</select>
				</label>				
				<label class="select">					
					<h4>Concelho Naturalidade:</h4>
						<select name="concelho" id="concelho"> 
							<option value=''>Selecione Concelho</option>
						</select>
				</label>
				<label class="select">
					<h4>Documento de Identificação:</h4>
						<select name="tipodoc" id="tipodoc" required>
							<option value=''>Selecione</option>
							<option value='BI'>Bilhete de Identidade</option>	
							<option value='cc'>Cartão Cidadão</option>	
							<option value='M'>Cartão de Identificação Militar</option>
							<option value='DCC'>Declaração de Dados Pessoais</option>
							<option value='PASSPT'>Passaporte</option>	
							<option value='TR'>Título de Residência</option>
							<option value='Outro'>Outro Documento de Identificação</option>
						</select>
				</label>
				<h4>Nº do documento de identificação:</h4>
					<label class="input">
						<input type="text" name="BI" id="BI" value="<?php echo $row['BI']; ?>">
						<br>(no caso do Cartão do Cidadão é obrigatório indicar os <strong>4 últimos dígitos</strong>)
					</label>						
					<br>
				<h4>Validade do documento de identificação:</h4>
					<label class="input">
						<input type="date" name="validade" id="validade" value="<?php echo $row['validade']; ?>">
					</label><br>
			</section>
			<section>
				<h2>Percurso Académico e Profissional</h2>
				<label class="select">
					<h4>Habilitações literárias/grau académico:</h4>
						<select name="habilitacoes" id="habilitacoes" required>
							<option value=''>Selecione</option>
							<option value='1' <?= $row['habilitacoes'] == '1'? 'selected' : ''; ?>>1º Ciclo</option>	
							<option value='2' <?= $row['habilitacoes'] == '2'? 'selected' : ''; ?>>2º Ciclo</option>
							<option value='3' <?= $row['habilitacoes'] == '3'? 'selected' : ''; ?>>9º Ano</option>	
							<option value='4' <?= $row['habilitacoes'] == '4'? 'selected' : ''; ?>>10º Ano (frequência)</option>
							<option value='5' <?= $row['habilitacoes'] == '5'? 'selected' : ''; ?>>10º Ano</option>	
							<option value='6' <?= $row['habilitacoes'] == '6'? 'selected' : ''; ?>>11º Ano</option>
							<option value='7' <?= $row['habilitacoes'] == '7'? 'selected' : ''; ?>>Ensino Secundário Recorrente</option>	
							<option value='8' <?= $row['habilitacoes'] == '8'? 'selected' : ''; ?>>Ensino Secundário</option>
							<option value='9' <?= $row['habilitacoes'] == '9'? 'selected' : ''; ?>>Frequência Universitária</option>	
							<option value='10' <?= $row['habilitacoes'] == '10'? 'selected' : ''; ?>>Bacharelato</option>
							<option value='11' <?= $row['habilitacoes'] == '11'? 'selected' : ''; ?>>Licenciatura</option>	
							<option value='12' <?= $row['habilitacoes'] == '12'? 'selected' : ''; ?>>Mestrado Integrado</option>
							<option value='13' <?= $row['habilitacoes'] == '13'? 'selected' : ''; ?>>Mestrado</option>	
							<option value='14' <?= $row['habilitacoes'] == '14'? 'selected' : ''; ?>>Pós-Graduação</option>
							<option value='15' <?= $row['habilitacoes'] == '15'? 'selected' : ''; ?>>Doutoramento</option>	
							<option value='16' <?= $row['habilitacoes'] == '16'? 'selected' : ''; ?>>Doutoranda</option>
						</select>
				<h4>Curso superior:</h4>
					<label class="input">
						<input type="text" name="cursosuperior" id="cursosuperior" value="<?php echo $row['cursosuperior']; ?>">
					</label><br>
				<h4>Instituição de ensino superior:</h4>
					<label class="select">
						<select name="instituicao" id="instituicao" class="select2-search">
							<option value=''>Selecione Instituição</option>
							<?php
								$stmt = $conn->prepare("SELECT * FROM escolas ORDER BY nome_escola asc");
								$stmt->execute();
								$listaescolas = $stmt->fetchAll();
								foreach ($listaescolas as $escola) {
									if($row['instituicao'] == $escola['Codigo_escola'])
										echo "<option value='" . $escola['Codigo_escola'] . "' selected>" . $escola['Nome_escola'] . "</option>";
									else echo "<option value='" . $escola['Codigo_escola'] . "'>" . $escola['Nome_escola'] . "</option>";
								}
							?>
						</select>
					</label><br>
				<h4>Profissão atual:</h4>
					<label class="select">
						<select name="profissao" id="profissao" class="select2-search" required>
							<option value=''>Selecione Profissão</option>
							<?php
								$stmt = $conn->prepare("SELECT * FROM funcoes ORDER BY funcao asc");
								$stmt->execute();
								$listafuncoes = $stmt->fetchAll();
								foreach ($listafuncoes as $funcao) {
									if($row['profissao'] == $funcao['Funcao'])
										echo "<option value='" . $funcao['Codigo_Funcao'] . "' selected>" . $funcao['Funcao'] . "</option>";
									else echo "<option value='" . $funcao['Codigo_Funcao'] . "'>" . $funcao['Funcao'] . "</option>";    							
								}
							?>
						</select>
					</label>
			</section>
			<section>
				<h2>Dados p/ Faturação</h2>
					<label for="chk-Yes">
						<input type="radio" id="chk-No" name="show-div" checked onclick="show1();" value="0" />
						Em nome do próprio: (restantes dados indicados acima)
					</label><br>
					<label for="chk-No">
						<input type="radio" id="chk-Yes" name="show-div" onclick="show2();" value="1" />
						Em nome de outrem:
					</label><br><br>

				<div id="div1" hidden>
					<h4>NIF:</h4>
						<label class="input">
							<input type="text" name="nif" minlength="9" placeholder = "000000000" pattern="\d{9}" id="niffaturacao" value="<?php echo $row['niffaturacao']; ?>">
						</label><br>
					<h4>Nome:</h4>
						<label class="input">
							<input type="text" name="nomefaturacao" id="nomefaturacao" value="<?php echo $row['nomefaturacao']; ?>">
						</label><br>
					<h4>Morada:</h4>
						<label class="input">
							<input type="text" name="moradafaturacao" id="moradafaturacao" value="<?php echo $row['moradafaturacao']; ?>">
						</label><br>
					<h4>Código Postal:</h4>
						<label class="input">
							<input type="text" name="codigopostalfaturacao" minlength="8" placeholder = "0000-000" pattern="\d{4}-\d{3}" id="codigopostalfaturacao" value="<?php echo $row['codigopostalfaturacao']; ?>">
						</label><br>
					<h4>Localidade:</h4>
						<label class="input">
							<input type="text" name="localidadefaturacao" id="localidadefaturacao" value="<?php echo $row['localidadefaturacao']; ?>">
						</label><br><br>
				</div>
				<p>1. Declaro que os dados acima indicados estão corretos e atualizados, assumindo responsabilidade sobre qualquer erro que possa ocorrer no processamento da minha inscrição e/ou emissão do certificado de conclusão por força dos dados indicados não estarem devidamente preenchidos.
				</p>
				<p>2. De acordo com o artigo 227º do Código Civil, declaro ainda que as informações prestadas são verdadeiras e assumo a inteira responsabilidade pelas mesmas.
				</p>
				<p>3. Todos os dados pessoais facultados ao Instituto CRIAP são tratados e para o efeito processados de acordo com a Lei de Proteção de dados n. º 58/2019 que assegura a execução na ordem jurídica nacional, o Regulamento (UE) 2016679 do Parlamento e Conselho, de 27 de abril de 2016.
				</p>
				<p>4. No cumprimento da legislação sobre a Proteção de Dados Pessoais esta entidade formadora garante a estrita confidencialidade no tratamento dos seus dados. A informação por si disponibilizada não será partilhada com terceiros e será apenas para os fins diretamente relacionados com a formação que vai frequentar e para execução do contrato de Formação.
				</p>
				<p>5. Ao inscrever-se numa formação no Instituto CRIAP será automaticamente inserido como subscritor/a da nossa newsletter.
					<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Caso não pretenda receber a newsletter do Instituto CRIAP, assinale com um “x”:
					<label style class="chckbox"><input id="escolhanewsletter" name="escolhanewsletter" type="checkbox"></label>
				</p>
				<p>6. Caso não autorize que os seus dados pessoais sejam facultados à DGERT para eventual auscultação, por parte do Sistema de Acreditação, sobre a qualidade da formação em que irá participar, assinale com um “x”:
					<label class="chckbox"><input name="escolhadgert" id="escolhadgert" type="checkbox"></label>
				</p>
			</section>
		</fieldset>
		<footer>
			<button type="submit" class="button">Enviar</button>
		</footer>
		<div class="message">
			<div style="background-color:#00a85f; text-align:justify; color:white; font: 13px/1.55 'Open Sans',Helvetica,Arial,sans-serif;">
				<br><strong>
					<p>Caro/a formando/a,</p>
					<p>Agradecemos a sua resposta.</p>
					<p>Caso surja alguma dificuldade, queira por favor contactar os nossos serviços (+351 225 492 190).</p>
					<br>
				</strong>
			</div>
		</div>
		</form>
		</div>
		<script type="text/javascript">
			function show1() {
				document.getElementById('div1').style.display = 'none';
			}
			function show2() {
				document.getElementById('div1').style.display = 'block';
			}
			const PoT_distrito = document.getElementById('distrito');
			const PoT_concelho = document.getElementById('concelho');
			const PoT_BI = document.getElementById('BI');

			function changePurpose(){
				const value = document.getElementById('pais').value;
				PoT_distrito.required = (value == "PT");
				PoT_concelho.required = false; // Removendo obrigatoriedade do concelho
				
				// O campo NISS é obrigatório apenas para Portugal
				const nissField = document.getElementById('niss');
				nissField.required = (value == "PT");
				if (value == "PT") {
					nissField.setAttribute("placeholder", "Número de Identificação de Segurança Social (obrigatório)");
				} else {
					nissField.setAttribute("placeholder", "Número de Identificação de Segurança Social (opcional)");
				}
			}
			$(document).ready(function() {
			    // Initialize variable to track Portugal country code
			    let isPT = false;
			    
			    // Set default country code for phone
			    $("#phone_country").val("+351");
			    
			    // Toggle distrito/concelho fields based on country
			    function toggleRegionFields() {
			        const distFields = $('#distrito, #concelho').closest('label');
			        if (isPT) {
			            distFields.show();
			        } else {
			            distFields.hide();
			        }
			    }
			    
			    // Format and validate phone number based on country
			    function updatePhoneValidation() {
			        const phone = $("#telemovel");
			        if (isPT) {
			            phone.attr("placeholder", "Número sem código do país");
			            phone.attr("minlength", "9");
			            phone.attr("maxlength", "9");
			            phone.mask('000000000', {reverse: false});
			        } else {
			            phone.unmask();
			            phone.attr("placeholder", "Número sem código do país");
			            phone.removeAttr("minlength maxlength");
			        }
			    }
			    
			    // Handle country selection
			    $('#pais').change(function() {
			        const countryId = $(this).val();
			        isPT = (countryId == "PT");
			        
			        // Update phone_country selector to match country
			        if (isPT) {
			            $("#phone_country").val("+351");
			        }
			        
			        // Update field validations
			        updatePhoneValidation();
			        toggleRegionFields();

					$('#distrito').find('option').not(':first').remove();
					$('#concelho').find('option').not(':first').remove();

					$.ajax({
						url: 'ajaxfile.php',
						type: 'post',
						data: {
							request: 1,
							countryid: countryId
						},
						dataType: 'json',
						success: function(response) {
							var len = response.length;
							for (var i = 0; i < len; i++) {
								var id = response[i]['id'];
								var name = response[i]['stateame'];
								$("#distrito").append("<option value='" + id + "'>" + name + "</option>");
							}
						}
					});
				});
				
				// NIF Estrangeiro checkbox
				$('#nifEstrangeiro').change(function() {
				    const isChecked = $(this).is(":checked");
				    const ncInput = $("#NC");
				    
				    if (isChecked) {
				        ncInput.unmask();
				        ncInput.removeAttr("pattern");
				    } else {
				        ncInput.mask('000000000', {reverse: false});
				        ncInput.attr("pattern", "\\d{9}");
				    }
				});
				
				// Set document ID validation based on document type
			    $('#tipodoc').change(function(){
        	        if($(this).val() == 'cc'){
    				    $("#BI").mask('00000000-0-AA0');
    				    $("#BI").attr("minlength", "14");
    				    $("#BI").attr("pattern", "[0-9]{8}-[0-9]{1}-[A-Z]{2}[0-9]{1}");
        	        } else if($(this).val() == 'BI') {
    				    $("#BI").mask('00000000');
    				    $("#BI").attr("minlength", "8");
    				    $("#BI").attr("pattern", "[0-9]{8}");
        	        } else {
    				    $("#BI").unmask();
    				    $("#BI").removeAttr("pattern");
    				}
			    });
			    
			    // Format postal code
			    var $campo = $("#codigopostal");
			    $campo.mask('0000-000', {reverse: false});
			    
			    var $campo = $("#codigopostalfaturacao");
			    $campo.mask('0000-000', {reverse: false});
			    
			    // Format NIF
			    var $campo2 = $("#NC");
			    $campo2.mask('000000000', {reverse: false});
			    
			    var $campo2 = $("#niffaturacao");
			    $campo2.mask('000000000', {reverse: false});
			    
			    // Initialize phone mask
			    var $campo3 = $("#telemovel");
			    $campo3.mask('000000000', {reverse: false});
			    
			    // Configurar máscara para o NISS - 11 dígitos
			    var $campoNiss = $("#niss");
			    $campoNiss.mask('00000000000', {reverse: false});
			    
			    // Call toggleRegionFields initially to set correct visibility
			    toggleRegionFields();
			    
			    $('#tipodoc').change(function(){
        	        if($(this).val() == 'cc'){
    				    $("#BI").mask('00000000-0-AA0');
    				    $("#BI").min('00000000-0-AA0');
        	        }
    				else $("#BI").unmask();
			    })
			    
			    var $campo = $("#codigopostal");
			    $campo.mask('0000-000', {reverse: false});
			    
			    var $campo = $("#codigopostalfaturacao");
			    $campo.mask('0000-000', {reverse: false});
			    
			    var $campo2 = $("#NC");
			    $campo2.mask('000000000', {reverse: false});
			    
			    var $campo2 = $("#niffaturacao");
			    $campo2.mask('000000000', {reverse: false});
			    
			    var $campo3 = $("#telemovel");
			    $campo3.mask('000000000', {reverse: false});
			    
				$('#pais').change(function() {
					var countryid = $(this).val();

					$('#distrito').find('option').not(':first').remove();
					$('#concelho').find('option').not(':first').remove();

					$.ajax({
						url: 'ajaxfile.php',
						type: 'post',
						data: {
							request: 1,
							countryid: countryid
						},
						dataType: 'json',
						success: function(response) {
							var len = response.length;
							for (var i = 0; i < len; i++) {
								var id = response[i]['id'];
								var name = response[i]['stateame'];
								$("#distrito").append("<option value='" + id + "'>" + name + "</option>");
							}
						}
					});
				})
				$('#distrito').change(function() {
					var stateid = $(this).val();

					$('#concelho').find('option').not(':first').remove();

					$.ajax({
						url: 'ajaxfile.php',
						type: 'post',
						data: {
							request: 2,
							stateid: stateid
						},
						dataType: 'json',
						success: function(response) {
							var len = response.length;
							for (var i = 0; i < len; i++) {
								var id = response[i]['id'];
								var cityname = response[i]['cityname'];
								$("#concelho").append("<option value='" + id + "'>" + cityname + "</option>");
							}
						}
					});
					});
				
				// Inicializa Select2 para os campos padrão (sem recursos avançados)
				$('.js-example-basic-single').select2();
				
				// Inicializa Select2 com bandeiras para o campo de país do telefone
				$(".select2-flags").select2({
					templateResult: formatFlag,
					templateSelection: formatFlag,
					escapeMarkup: function(m) { return m; }
				});
				
				// Inicializa Select2 para os campos com pesquisa
				$(".select2-search").select2({
					placeholder: "Pesquisar...",
					allowClear: true
				});
				
				// Função para formatar as opções com bandeiras
				function formatFlag(state) {
					if (!state.id) return state.text;
					var flag = $(state.element).data('flag');
					if (!flag) return state.text;
					return '<span class="flag-icon flag-icon-' + flag + '"></span> ' + state.text;
				}
				
				$(function() {
				});
						        
				$('.js-example-basic-single').select2();
				$(function() {
					$.validator.messages.required = "Por favor preencha todos os campos!";
                    
                    // Add custom validation methods
                    $.validator.addMethod("hasThreeNames", function(value, element) {
                        if (!value) return true; // Skip validation if empty (required will handle this)
                        const names = value.trim().split(/\s+/);
                        return names.length >= 3;
                    }, "O nome completo deve ter pelo menos 3 nomes.");
                    
                    $.validator.addMethod("validPostalCode", function(value, element) {
                        if (!value) return true;
                        return /^\d{4}-\d{3}$/.test(value);
                    }, "O código postal deve ter o formato 0000-000.");
                    
                    $.validator.addMethod("notRepeatingChars", function(value, element) {
                        if (!value) return true;
                        // Check for repeating characters (more than 5 of the same)
                        return !/(.)\1{4,}/.test(value);
                    }, "Não é permitido repetir o mesmo caractere muitas vezes.");
                    
                    $.validator.addMethod("noEmailPlus", function(value, element) {
                        if (!value) return true;
                        return value.indexOf('+') === -1;
                    }, "O e-mail não pode conter o caractere '+'.");
                    
                    $.validator.addMethod("personNIF", function(value, element) {
                        if (!value) return true;
                        if ($("#nifEstrangeiro").is(":checked")) return true;
                        
                        // Check if starts with 1, 2, or 3
                        return /^[123]\d{8}$/.test(value);
                    }, "O NIF deve começar com 1, 2 ou 3 (pessoa singular).");
                    
                    $.validator.addMethod("minimumAge", function(value, element) {
                        if (!value) return true;
                        // Calculate if person is at least 18 years old
                        const today = new Date();
                        const birthDate = new Date(value);
                        let age = today.getFullYear() - birthDate.getFullYear();
                        const monthDiff = today.getMonth() - birthDate.getMonth();
                        
                        if (monthDiff < 0 || (monthDiff === 0 && today.getDate() < birthDate.getDate())) {
                            age--;
                        }
                        
                        return age >= 18;
                    }, "O formando deve ser maior de idade.");
                    
                    $.validator.addMethod("futureDate", function(value, element) {
                        if (!value) return true;
                        const inputDate = new Date(value);
                        const today = new Date();
                        
                        // Set time to beginning of day for proper comparison
                        today.setHours(0, 0, 0, 0);
                        
                        return inputDate > today;
                    }, "A data deve ser posterior à data atual.");
                    
                    $.validator.addMethod("rfc5322Email", function(value, element) {
                        if (!value) return true;
                        const emailRegex = /^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$/;
                        return emailRegex.test(value);
                    }, "Por favor insira um endereço de email válido.");
                    
                    // Function to determine document ID requirements
                    function isRequiredBySelection() {
                       var selectedVal = $('select[name="tipodoc"]').val();
                       if (selectedVal === 'cc') return '14';
                       if (selectedVal === 'BI') return '8';
                       return '1';
                    }
                    
					$("#sky-form").validate({
						rules: {
							nomecompleto: {
								required: true,
								hasThreeNames: true
							},
							sexo: {
								required: true
							},
							morada: {
								required: true
							},
							codigopostal: {
								required: true,
								validPostalCode: true
							},
							localidade: {
								required: true
							},
							telemovel: {
								required: true,
								digits: true
							},
							email: {
								required: true,
								rfc5322Email: true,
								noEmailPlus: true
							},
							BI: {
								required: true,
								minlength: isRequiredBySelection
							},
							datanascimento: {
								required: true,
								date: true,
								minimumAge: true
							},
							nacionalidade: {
								required: true
							},
							niss: {
								required: true,
								digits: true,
								minlength: 11,
								maxlength: 11
							},
							estado_civil: {
								required: true
							},
							pais: {
								required: true
							},
							tipodoc: {
								required: true
							},
							NC: {
								required: true,
								digits: true,
								personNIF: true
							},
							validade: {
								required: true,
								date: true,
								futureDate: true
							},
							habilitacoes: {
								required: true
							},
							cursosuperior: {
								required: true
							},
							profissao: {
								required: true
							},
							nif: {
								required: {
									depends: document.getElementById("chk-Yes").checked
								}
							},
							nomefaturacao: {
								required: {
									depends: document.getElementById("chk-Yes").checked
								}
							},
							moradafaturacao: {
								required: {
									depends: document.getElementById("chk-Yes").checked
								}
							},
							codigopostalfaturacao: {
								required: {
									depends: document.getElementById("chk-Yes").checked
								}
							},
							localidadefaturacao: {
								required: {
									depends: document.getElementById("chk-Yes").checked
								}
							},
						},
						messages: {
							nomecompleto: {
								required: "Por favor insira o seu Nome Completo!"
							},
							morada: {
								required: "Por favor insira uma morada!"
							},
							codigopostal: {
								required: "Por favor insira um código de postal!"
							},
							localidade: {
								required: "Por favor insira uma Localidade!"
							},
							telemovel: {
								required: "Por favor insira o seu contacto!"
							},
							email: {
								required: "Por favor insira um endereço de email!"
							},
							user_idnumber2: {
								required: "Por favor insira um número de contribuinte!"
							},
							datanascimento: {
								required: "Por favor insira a data de Nascimento!"
							},
							niss: {
								required: "Por favor insira o Número de Identificação de Segurança Social!",
								digits: "O NISS deve conter apenas números!",
								minlength: "O NISS deve ter exatamente 11 dígitos!",
								maxlength: "O NISS deve ter exatamente 11 dígitos!"
							},
							estado_civil: {
								required: "Por favor selecione o Estado Civil!"
							},
							nacionalidade: {
								required: "Por favor insira o Nacionalidade!"
							},
							pais: {
								required: "Por favor insira o Pais!"
							},
							distrito: {
								required: "Por favor insira o Distrito!"
							},
							concelho: {
								required: "Por favor insira o Concelho!"
							},
							docid: {
								required: "Por favor escolha o tipo de Documento de Identificação!"
							},
							outro: {
								required: "Por favor escolha o tipo de Documento de Identificação!"
							},
							NC: {
								required: "Por favor insira o Número de Identificação Fiscal!"
							},
							validade: {
								required: "Por favor insira a validade do Documento de Identificação!"
							},
							habilitacoes: {
								required: "Por favor preencha as Habilitações!"
							},
							cursosuperior: {
								required: "Por favor preencha as Habilitações!"
							},
							instituicao: {
								required: "Por favor preencha as Habilitações!"
							},
							profissao: {
								required: "Por favor insira a Profissão!"
							},
							nif: {
								required: "Por favor insira um Número de Identificação Fiscal para Faturação!"
							},
							nomefaturacao: {
								required: "Por favor insira o Nome para Faturação!"
							},
							moradafaturacao: {
								required: "Por favor insira uma morada para Faturação!"
							},
							codigopostalfaturacao: {
								required: "Por favor insira um código de postal para Faturação!"
							},
							localidadefaturacao: {
								required: "Por favor insira uma Localidade para Faturação!"
							},
						},
						submitHandler: function(form) {
						    
                        let text = "Caro/a Formando/a antes de enviar os seus dados pessoais, queira por favor confirmar se os mesmos estão corretamente preenchidos!";
                        text += "\nOs seus dados pessoais serão apresentados no seu Certificado de Formação Profissional!";
                        text += "\n\nEvite o bloqueio do seu processo de Certificação.\n\nObrigada, Instituto CRIAP";
					        
                            if (confirm(text) == true) {
                                
    							var news = 0;
    							var dgert = 0;
    							var nif = 0;
    							var outro = "";
    							if (document.getElementById("escolhanewsletter").checked == true)
    								news = 1;
    							if (document.getElementById("escolhadgert").checked == true)
    								dgert = 1;
    							if (document.getElementById("chk-Yes").checked == true)
    								nif = 1;
    							if (document.querySelector('input[name="docid"]:checked')?.value == "Outro")
    								outro = "," + document.getElementById("outro").value;
    
    							var data = {
    								id: <?php echo json_encode($id); ?>,
    								course_id: <?php echo json_encode($course_id); ?>,
    								user_idnumber: <?php echo json_encode($user_idnumber); ?>,
    								nomecompleto: document.getElementById('nomecompleto')?.value,
    								sexo: document.querySelector("input[name=sexo]:checked").value,
    								morada: document.getElementById('morada')?.value,
    								codigopostal: document.getElementById('codigopostal')?.value,
    								localidade: document.getElementById('localidade')?.value,
    								telemovel: formatPhoneNumber(),
    								phone_country: document.getElementById('phone_country')?.value,
    								email: document.getElementById('email')?.value,
    								tipodoc: document.getElementById('tipodoc')?.value,
    								tipodoctexto: document.getElementById('tipodoc').options[document.getElementById('tipodoc').selectedIndex].text,
    								BI: document.getElementById('BI')?.value,
    								NC: document.getElementById('NC')?.value,
    								validade: document.getElementById('validade')?.value,
    								datanascimento: document.getElementById('datanascimento')?.value,
    								niss: document.getElementById('niss')?.value,
    								estado_civil: document.getElementById('estado_civil')?.value,
    								pais: document.getElementById('pais')?.value,    
    								paistexto: document.getElementById('pais').options[document.getElementById('pais').selectedIndex].text,
    								nacionalidade: document.getElementById('nacionalidade')?.value,
    								nacionalidadeTexto: document.getElementById('nacionalidade').options[document.getElementById('nacionalidade').selectedIndex].text,
    								distrito: document.getElementById('distrito')?.value,
    								distritotexto: document.getElementById('distrito').options[document.getElementById('distrito').selectedIndex].text,
    								concelho: document.getElementById('concelho')?.value,
								    concelhotexto: document.getElementById('concelho').options[document.getElementById('concelho').selectedIndex].text,
    								habilitacoes: document.getElementById('habilitacoes')?.value,
    								habilitacoestexto: document.getElementById('habilitacoes').options[document.getElementById('habilitacoes').selectedIndex].text,
    								cursosuperior: document.getElementById('cursosuperior')?.value,
    								instituicao: document.getElementById('instituicao')?.value,
    								instituicaotexto: document.getElementById('instituicao').options[document.getElementById('instituicao').selectedIndex].text,
    								profissao: document.getElementById('profissao')?.value,
    								profissaotexto: document.getElementById('profissao').options[document.getElementById('profissao').selectedIndex].text,
    								escolhanif: nif,
    								niffaturacao: document.getElementById('niffaturacao')?.value,
    								nomefaturacao: document.getElementById('nomefaturacao')?.value,
    								moradafaturacao: document.getElementById('moradafaturacao')?.value,
    								codigopostalfaturacao: document.getElementById('codigopostalfaturacao')?.value,
    								localidadefaturacao: document.getElementById('localidadefaturacao')?.value,
    								escolhanewsletter: news,
    								escolhadgert: dgert,
    								curso: document.getElementById('curso')?.value
    							}
    							$(form).ajaxSubmit({
    								type: "post",
    								url: "inscricaosend.php",
    								data: data,
    								cache: false,
    								beforeSend: function() {
    									$('#sky-form button[type="submit"]').attr('disabled', true);
    								},
    								success: function(data) {
    									$("#sky-form").addClass('submited');
    								}
    							});
                            }
						},
						// Do not change code below
						errorPlacement: function(error, element) {
							error.insertAfter(element.parent());
						}
					});
				});
			});

			// Format phone number based on country selection
			function formatPhoneNumber() {
				const phoneCountry = document.getElementById('phone_country')?.value;
				const phoneNumber = document.getElementById('telemovel')?.value;
				const countryId = document.getElementById('pais')?.value;
				
				// If country is Portugal, just return the phone number without country code
				if (countryId === "PT") {
					return phoneNumber;
				}
				
				// For other countries, prepend the country code
				if (phoneCountry && phoneNumber) {
					return phoneCountry + phoneNumber;
				}
				
				return phoneNumber;
			}
		</script>
			<?php
					}
				}
			} catch (PDOException $e) {
				echo $e->getMessage();
				echo '<script>console.log("' . $e->getMessage() . '")</script>';
			}
			?>